// controllers/responsablesController.js
const { poolPromise } = require('../config/db');

// Listar todos los responsables con su cargo
exports.getResponsables = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT r.id_responsable,
             r.nombre_responsable,
             r.tipo,
             c.id_cargo,
             c.nombre_cargo AS cargo,
             r.telefono,
             r.correo
      FROM Responsables r
      LEFT JOIN Cargos c ON r.id_cargo = c.id_cargo
      ORDER BY r.nombre_responsable ASC;
    `);
    res.json(result.recordset);
  } catch (err) {
    console.error("❌ Error al obtener responsables:", err);
    res.status(500).json({ ok: false, message: "Error al obtener responsables" });
  }
};

// Listar cargos (catálogo)
exports.getCargos = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT id_cargo, nombre_cargo
      FROM Cargos
      ORDER BY nombre_cargo ASC;
    `);
    res.json(result.recordset);
  } catch (err) {
    console.error("❌ Error al obtener cargos:", err);
    res.status(500).json({ ok: false, message: "Error al obtener cargos" });
  }
};

// Crear responsable
exports.createResponsable = async (req, res) => {
  try {
    const { nombre_responsable, tipo, id_cargo, telefono, correo } = req.body;

    // Validación mínima
    if (!nombre_responsable || !tipo) {
      return res.status(400).json({ ok: false, message: "Faltan campos obligatorios" });
    }

    const pool = await poolPromise;
    await pool.request()
      .input('nombre_responsable', nombre_responsable)
      .input('tipo', tipo)
      .input('id_cargo', id_cargo || null)
      .input('telefono', telefono || null)
      .input('correo', correo || null)
      .query(`
        INSERT INTO Responsables (nombre_responsable, tipo, id_cargo, telefono, correo)
        VALUES (@nombre_responsable, @tipo, @id_cargo, @telefono, @correo);
      `);

    res.status(201).json({ ok: true, message: "Responsable agregado correctamente" });
  } catch (err) {
    console.error("❌ Error al crear responsable:", err);
    res.status(500).json({ ok: false, message: "Error al crear responsable" });
  }
};

// Actualizar responsable
exports.updateResponsable = async (req, res) => {
  try {
    const { id } = req.params;
    const { nombre_responsable, tipo, id_cargo, telefono, correo } = req.body;

    const pool = await poolPromise;
    await pool.request()
      .input('id', id)
      .input('nombre_responsable', nombre_responsable)
      .input('tipo', tipo)
      .input('id_cargo', id_cargo || null)
      .input('telefono', telefono || null)
      .input('correo', correo || null)
      .query(`
        UPDATE Responsables
        SET nombre_responsable = @nombre_responsable,
            tipo = @tipo,
            id_cargo = @id_cargo,
            telefono = @telefono,
            correo = @correo
        WHERE id_responsable = @id;
      `);

    res.json({ ok: true, message: "Responsable actualizado correctamente" });
  } catch (err) {
    console.error("❌ Error al actualizar responsable:", err);
    res.status(500).json({ ok: false, message: "Error al actualizar responsable" });
  }
};

// Eliminar responsable
exports.deleteResponsable = async (req, res) => {
  try {
    const { id } = req.params;
    const pool = await poolPromise;
    await pool.request()
      .input('id', id)
      .query(`DELETE FROM Responsables WHERE id_responsable = @id;`);

    res.json({ ok: true, message: "Responsable eliminado correctamente" });
  } catch (err) {
    console.error("❌ Error al eliminar responsable:", err);
    res.status(500).json({ ok: false, message: "Error al eliminar responsable" });
  }
};
