// controllers/usuariosController.js
const { poolPromise } = require("../config/db");
const bcrypt = require("bcryptjs");

// 🧾 Obtener todos los usuarios
exports.getUsuarios = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT 
        u.id_usuario, 
        u.nombre_completo, 
        u.usuario, 
        u.correo, 
        u.id_rol,
        r.nombre_rol, 
        CASE 
          WHEN u.estado = 1 THEN 'Activo'
          ELSE 'Inactivo'
        END AS estado,
        CONVERT(VARCHAR, u.fecha_creacion, 103) AS fecha_creacion
      FROM Usuarios u
      INNER JOIN Roles r ON u.id_rol = r.id_rol
    `);

    res.json(result.recordset);
  } catch (error) {
    console.error("❌ Error al obtener usuarios:", error);
    res.status(500).send("Error al obtener usuarios");
  }
};

// ➕ Crear nuevo usuario
exports.createUsuario = async (req, res) => {
  try {
    const { nombre_completo, usuario, correo, contrasena, id_rol } = req.body;
    const pool = await poolPromise;

    const hashed = await bcrypt.hash(contrasena, 10);

    await pool.request()
      .input("nombre_completo", nombre_completo)
      .input("usuario", usuario)
      .input("correo", correo)
      .input("contrasena", hashed)
      .input("id_rol", id_rol)
      .query(`
        INSERT INTO Usuarios (nombre_completo, usuario, correo, contrasena, id_rol)
        VALUES (@nombre_completo, @usuario, @correo, @contrasena, @id_rol)
      `);

    res.json({ message: "Usuario creado correctamente ✅" });
  } catch (error) {
    console.error("❌ Error al crear usuario:", error);
    res.status(500).send("Error al crear usuario");
  }
};

// controllers/usuariosController.js
// REEMPLAZA SOLO LA FUNCIÓN updateUsuario CON ESTA

// ✏️ Actualizar usuario
exports.updateUsuario = async (req, res) => {
  try {
    const { id } = req.params;
    const { nombre_completo, correo, id_rol, estado } = req.body;

    // 🔥 CORRECCIÓN DEL BUG:
    // Convertimos el estado de texto ("Activo" / "Inactivo") a número (1 / 0)
    // ya que la base de datos espera un número (según tu SELECT).
    const estadoNumerico = estado === "Activo" ? 1 : 0;

    const pool = await poolPromise;
    await pool.request()
      .input("id", id)
      .input("nombre_completo", nombre_completo)
      .input("correo", correo)
      .input("id_rol", id_rol)
      .input("estado", estadoNumerico) // Usamos la variable corregida
      .query(`
        UPDATE Usuarios
        SET nombre_completo = @nombre_completo,
            correo = @correo,
            id_rol = @id_rol,
            estado = @estado
        WHERE id_usuario = @id
      `);

    res.json({ message: "Usuario actualizado correctamente ✅" });
  } catch (error) {
    console.error("❌ Error al actualizar usuario:", error);
    res.status(500).send("Error al actualizar usuario");
  }
};
// 🗑️ Eliminar usuario
exports.deleteUsuario = async (req, res) => {
  try {
    const { id } = req.params;
    const pool = await poolPromise;
    await pool.request()
      .input("id", id)
      .query(`DELETE FROM Usuarios WHERE id_usuario = @id`);
    res.json({ message: "Usuario eliminado correctamente 🗑️" });
  } catch (error) {
    console.error("❌ Error al eliminar usuario:", error);
    res.status(500).send("Error al eliminar usuario");
  }
};
