// routes/caidasRoutes.js
const express = require("express");
const router = express.Router();
const caidasController = require("../controllers/caidasController");
const { verificarPermiso } = require("../middleware/permisosMiddleware");

// 🧪 Ruta de prueba
router.get("/test", (req, res) => {
  res.send("Ruta de caídas funcionando correctamente ✅");
});

// 📋 CRUD completo
router.get("/", verificarPermiso("caidas"), caidasController.getCaidas);
router.post("/", verificarPermiso("caidas"), caidasController.createCaida);
router.put("/:id", verificarPermiso("caidas"), caidasController.updateCaida);
router.delete("/:id", verificarPermiso("caidas"), caidasController.deleteCaida);

module.exports = router;
