// routes/incidentesRoutes.js
const express = require("express");
const router = express.Router();
const incidentesController = require("../controllers/incidentesController");

// 🔹 Ruta de prueba
router.get("/test", (req, res) => {
  res.send("Ruta de incidentes funcionando correctamente ✅");
});

// 🔹 Rutas principales del CRUD
router.get("/", incidentesController.getIncidentes); // Leer todos
router.post("/", incidentesController.createIncidente); // Crear
router.put("/:id", incidentesController.updateIncidente); // Actualizar
router.delete("/:id", incidentesController.deleteIncidente); // Eliminar

module.exports = router;
