// controllers/monitoreoController.js
const { poolPromise } = require("../config/db");

// ✅ Estado de los activos críticos
const obtenerEstadoServicios = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT 
        nombre_activo AS nombre,
        estado
      FROM Activos
      ORDER BY criticidad DESC, nombre_activo;
    `);
    res.json(result.recordset);
  } catch (err) {
    console.error("❌ Error al obtener estado de servicios:", err);
    res.status(500).send("Error al obtener estado de servicios");
  }
};

// ✅ Registro de caídas e interrupciones (versión con tus columnas reales)
const obtenerCaidas = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT 
        CONVERT(VARCHAR, fecha_inicio, 103) AS fecha,
        duracion_min AS duracion,
        causa,
        estado
      FROM Caidas
      ORDER BY fecha_inicio DESC;
    `);
    res.json(result.recordset);
  } catch (err) {
    console.error("❌ Error al obtener registro de caídas:", err);
    res.status(500).send("Error al obtener registro de caídas");
  }
};

module.exports = {
  obtenerEstadoServicios,
  obtenerCaidas,
};
